// Script automático para Illustrator
// Exporta el artboard activo 5 veces con nombres predefinidos sin pedir carpeta

// Obtener documento activo
var doc = app.activeDocument;

// Obtener artboard activo
var abIndex = doc.artboards.getActiveArtboardIndex();
var artboardNombre = doc.artboards[abIndex].name;

// Lista de nombres para exportar
var nombres = ["Canal13", "BioBio", "Cooperativa", "El_Mercurio", "DV360_OX_PMP"];

// Ruta de destino (modifícala según tu PC)
// Ejemplo: en Windows "C:\Users\alfon\Desktop\test"
// Ejemplo: en Mac "/Users/Usuario/Desktop/Exports"
var rutaDestino = "C:/Users/alfon/Desktop/BOND/2025/01. BCI/09_SEPTIEMBRE/11_La Roja Mundial Sub 20/GRILLA"; // <-- Cambia esto a tu ruta

// Crear la carpeta si no existe
var carpetaDestino = new Folder(rutaDestino);
if (!carpetaDestino.exists) carpetaDestino.create();

// Asegurarse que el artboard activo esté seleccionado
doc.artboards.setActiveArtboardIndex(abIndex);

// Exportar cada nombre
for (var i = 0; i < nombres.length; i++) {
    var archivo = new File(carpetaDestino + "/" + nombres[i] + "_" + artboardNombre + ".jpg");
    var opciones = new ExportOptionsJPEG();
    opciones.qualitySetting = 80;
    opciones.artBoardClipping = true;
    doc.exportFile(archivo, ExportType.JPEG, opciones);
}

alert("Exportación completada: " + nombres.length + " archivos creados para el artboard: " + artboardNombre);
